import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { useIntl } from 'tachyon-intl';
import { getFormattedUserDisplayName } from 'tachyon-utils';
import { ScheduleTitle } from './ScheduleTitle';
import type { LastStreamTitle_video } from './__generated__/LastStreamTitle_video.graphql';

type LastStreamTitleProps = {
  user: { displayName: string; login: string };
  video: LastStreamTitle_video;
};

// istanbul ignore next: trivial
export const LastStreamTitleBase: FC<LastStreamTitleProps> = ({
  user,
  video,
}) => {
  const { formatDate, formatMessage } = useIntl();

  if (!video.publishedAt) {
    return null;
  }

  const displayName = getFormattedUserDisplayName(user);
  const dateString = formatDate(new Date(video.publishedAt), {
    day: 'numeric',
    month: 'long',
    year: 'numeric',
  });

  const message = formatMessage(
    '{displayName} last streamed on {dateString}.',
    { dateString, displayName },
    'ChannelSchedulePageLastStreamTitle',
  );

  return <ScheduleTitle>{message}</ScheduleTitle>;
};

LastStreamTitleBase.displayName = 'LastStreamTitle';

export const LastStreamTitle = createFragmentContainer(LastStreamTitleBase, {
  video: graphql`
    fragment LastStreamTitle_video on Video {
      id
      publishedAt
    }
  `,
});
