import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { getFormattedUserDisplayName } from 'tachyon-utils';
import { ScheduleTitle } from './ScheduleTitle';

type LiveTitleProps = {
  user: {
    displayName: string;
    login: string;
  };
};

// istanbul ignore next: trivial
export const LiveTitle: FC<LiveTitleProps> = ({ user }) => {
  const { formatMessage } = useIntl();

  const displayName = getFormattedUserDisplayName(user);
  const message = formatMessage(
    '{displayName} is live!',
    { displayName },
    'ChannelSchedulePageLiveTitle',
  );

  return <ScheduleTitle>{message}</ScheduleTitle>;
};

LiveTitle.displayName = 'LiveTitle';
