import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { useIntl } from 'tachyon-intl';
import { getFormattedUserDisplayName } from 'tachyon-utils';
import { ScheduleTitle } from './ScheduleTitle';
import type { NextSegmentTitle_segment } from './__generated__/NextSegmentTitle_segment.graphql';

type NextSegmentTitleProps = {
  segment: NextSegmentTitle_segment;
  user: {
    displayName: string;
    login: string;
  };
};

// istanbul ignore next: trivial
export const NextSegmentTitleBase: FC<NextSegmentTitleProps> = ({
  segment,
  user,
}) => {
  const { formatDate, formatMessage, formatTime } = useIntl();
  const startAt = new Date(segment.startAt);
  const dateString = formatDate(startAt, { day: 'numeric', month: 'numeric' });
  const timeString = formatTime(startAt, {
    hour: 'numeric',
    hour12: true,
    minute: '2-digit',
  });

  const displayName = getFormattedUserDisplayName(user);
  const message = formatMessage(
    "{displayName}'s next stream is on {dateString} at {timeString}.",
    { dateString, displayName, timeString },
    'ChannelSchedulePageNextSegmentTitle',
  );

  return <ScheduleTitle>{message}</ScheduleTitle>;
};

NextSegmentTitleBase.displayName = 'NextSegmentTitle';

export const NextSegmentTitle = createFragmentContainer(NextSegmentTitleBase, {
  segment: graphql`
    fragment NextSegmentTitle_segment on ScheduleSegment {
      id
      startAt
    }
  `,
});
