import type { FC } from 'react';
import { useState } from 'react';
import { useIntl } from 'tachyon-intl';
import {
  Button,
  ButtonSize,
  ButtonType,
  Layout,
  Overflow,
  SVGAsset,
} from 'twitch-core-ui';
import { UpsellSheet } from '../../common';

const BRANCH_CAMPAIGN = 'remind_me_upsell';

// istanbul ignore next: trivial
export const RemindMeButton: FC = () => {
  const { formatMessage } = useIntl();
  const [isUpsellOpen, setIsUpsellOpen] = useState(false);

  const onClick = () => {
    setIsUpsellOpen(true);
  };

  return (
    <>
      <Layout flexShrink={0} overflow={Overflow.Hidden}>
        <Button
          icon={SVGAsset.NotificationBell}
          onClick={onClick}
          size={ButtonSize.Small}
          variant={ButtonType.Secondary}
        >
          {formatMessage('Remind me', 'RemindMeButton')}
        </Button>
      </Layout>
      {isUpsellOpen && (
        <UpsellSheet
          branchCampaign={BRANCH_CAMPAIGN}
          buttonText={formatMessage('Open App', 'RemindMeButton')}
          callToActionIdentifier="remind_me_button"
          description={formatMessage(
            'Set a reminder when scheduled stream starts so you don’t miss out on the action',
            'RemindMeButton',
          )}
          onClose={() => {
            setIsUpsellOpen(false);
          }}
          title={formatMessage(
            'Open the app and set a reminder!',
            'RemindMeButton',
          )}
        />
      )}
    </>
  );
};

RemindMeButton.displayName = 'RemindMeButton';
