import { getRelativeDate, olderThanOneWeek } from '.';

describe(olderThanOneWeek, () => {
  it('returns false when date is older than a week', () => {
    const tenDaysAgo = getRelativeDate(new Date(), { days: -10 });
    expect(olderThanOneWeek(tenDaysAgo.toISOString())).toBe(true);
  });

  it('returns true when date is not older than a week', () => {
    const twoDaysAgo = getRelativeDate(new Date(), { days: -2 });
    expect(olderThanOneWeek(twoDaysAgo.toISOString())).toBe(false);
  });
});
