import type { FC } from 'react';
import { useStaticEnvironment } from 'tachyon-environment';
import { isBrowser } from 'tachyon-utils';
import { WOODSTOCK_PLATFORM } from '../../../../config';
import { RouteName, useTachyonRouter } from '../../../../routing';

type SafetyDirectorProps = { login: string };

/**
 * Ensures that standalone channel page is only rendered when the app platform
 * has been set to woodstock. Otherwise, once in the browser this component
 * will force a redirect to the home page.
 */
export const SafetyDirector: FC<SafetyDirectorProps> = ({ login }) => {
  const router = useTachyonRouter();
  const {
    common: { platform },
  } = useStaticEnvironment();

  if (isBrowser() && platform !== WOODSTOCK_PLATFORM) {
    router.push({
      route: RouteName.Channel,
      routeParams: {
        login,
      },
    });
  }

  return null;
};
