import { random } from 'faker';
import { useStaticEnvironment } from 'tachyon-environment';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { isBrowser } from 'tachyon-utils';
import { WOODSTOCK_PLATFORM } from '../../../../config';
import { RouteName } from '../../../../routing';
import { mockRouter } from '../../../../routing/test-mocks';
import { SafetyDirector } from '.';

jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useStaticEnvironment: jest.fn(),
}));
const mockUseStaticEnvironment = useStaticEnvironment as jest.Mock;

jest.mock('tachyon-utils', () => ({
  ...jest.requireActual('tachyon-utils'),
  isBrowser: jest.fn(),
}));
const mockIsBrowser = isBrowser as jest.Mock;

jest.mock('../../../../routing', () => ({
  RouteName: { Homepage: 'home' },
  useTachyonRouter: () => mockRouter,
}));

describe(SafetyDirector, () => {
  const setup = createShallowWrapperFactory(SafetyDirector, () => ({
    login: random.alphaNumeric(16),
  }));

  beforeEach(() => {
    mockUseStaticEnvironment.mockReset();
    mockIsBrowser.mockReset();
  });

  it('redirects when in browser and platform is not woodstock', () => {
    mockUseStaticEnvironment.mockImplementationOnce(() => ({
      common: { platform: 'not_woodstock' },
    }));
    mockIsBrowser.mockImplementationOnce(() => true);

    const {
      props: { login },
    } = setup();

    expect(mockRouter.push).toHaveBeenCalledWith({
      route: RouteName.Channel,
      routeParams: { login },
    });
  });

  it('does not redirect when in browser and platform is woodstock', () => {
    mockUseStaticEnvironment.mockImplementationOnce(() => ({
      common: { platform: WOODSTOCK_PLATFORM },
    }));
    mockIsBrowser.mockImplementationOnce(() => true);

    setup();

    expect(mockRouter.push).not.toHaveBeenCalled();
  });

  it('does not redirect when not in browser and platform is not woodstock', () => {
    mockUseStaticEnvironment.mockImplementationOnce(() => ({
      common: { platform: 'not_woodstock' },
    }));
    mockIsBrowser.mockImplementationOnce(() => false);

    setup();

    expect(mockRouter.push).not.toHaveBeenCalled();
  });
});
