import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { StreamTagList } from '../../../common';
import { StandaloneStreamInfoBoxBase } from '.';

describe(StandaloneStreamInfoBoxBase, () => {
  const setup = createShallowWrapperFactory(
    StandaloneStreamInfoBoxBase,
    () => ({
      channel: {
        ' $refType': 'StandaloneStreamInfoBox_channel',
        broadcastSettings: {
          title: 'hola',
        },
        displayName: 'hola',
        login: 'hola',
        profileImageURL: 'image',
        stream: null,
      },
      relay: { refetch: jest.fn() } as any,
    }),
  );

  it('does not render StreamTagList when no stream is returned', () => {
    const { wrapper } = setup({
      channel: {
        ' $refType': 'StandaloneStreamInfoBox_channel',
        broadcastSettings: {
          title: 'hola',
        },
        displayName: 'hola',
        login: 'hola',
        profileImageURL: 'image',
        stream: {},
      },
    });

    expect(wrapper.find(StreamTagList)).not.toExist();
  });
});
