import { datatype, internet } from 'faker';
import Router from 'next/router';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { isBrowser } from 'tachyon-utils';
import { NotFoundErrorLayout, PlayerLayout } from '../../layouts';
import { ChannelStandalone } from '.';

jest.mock('tachyon-utils', () => ({
  ...jest.requireActual('tachyon-utils'),
  isBrowser: jest.fn(),
}));
const mockIsBrowser = isBrowser as jest.Mock;

jest.mock('../../../workers/chat.worker', () => jest.fn());

describe(ChannelStandalone, () => {
  let mockRouterPush: jest.SpyInstance;

  const setup = createShallowWrapperFactory(ChannelStandalone, () => {
    const login = internet.userName();

    return {
      channel: {
        ' $fragmentRefs': {
          StandaloneStreamInfoBox_channel: true,
          StreamPlayer_channel: true,
        },
        displayName: internet.userName(),
        hosting: null,
        id: datatype.uuid(),
        login,
        stream: {
          id: datatype.uuid(),
        },
      },
      queryVariables: {
        login,
      },
    };
  });

  beforeEach(() => {
    mockRouterPush = jest.spyOn(Router, 'push');
  });

  describe('instance methods', () => {
    describe('constructor', () => {
      beforeEach(() => {
        mockIsBrowser.mockReset();
        mockRouterPush.mockReset();
      });

      it('does not client-side redirect if not in browser', () => {
        mockIsBrowser.mockImplementationOnce(() => false);
        setup({ channel: {} });
        expect(mockRouterPush).not.toHaveBeenCalled();
      });

      it('does not client-side redirect if in browser', () => {
        mockIsBrowser.mockImplementationOnce(() => true);
        setup({
          channel: {},
        });
        expect(mockRouterPush).not.toHaveBeenCalled();
      });
    });
  });

  it('renders a Stream Player when the channel is found', () => {
    const { wrapper } = setup();
    expect(wrapper.find(PlayerLayout)).toExist();
  });

  it('renders a not found page when the channel is not found', () => {
    const { wrapper } = setup({ channel: null });
    expect(wrapper.find(NotFoundErrorLayout)).toExist();
  });
});
