import { datatype, lorem } from 'faker';
import {
  createMountWrapperFactory,
  createShallowWrapperFactory,
} from 'tachyon-test-utils';
import { CoreLink } from 'twitch-core-ui';
import { ChannelEmptyState, InfiniteList, VideoCard } from '../../../common';
import type { VideoShelfType } from './__generated__/ChannelVideosShelves_channel.graphql';
import { ChannelVideosShelvesBase } from '.';

jest.mock('../../../common', () => ({
  ...jest.requireActual('../../../common'),
  VideoCard: () => 'VideoCard',
}));

const mockShelf = (type: VideoShelfType = 'ALL_VIDEOS') => ({
  description: lorem.words(),
  id: datatype.uuid(),
  items: [
    {
      ' $fragmentRefs': { VideoCard_video: true as const },
      __typename: 'Video' as const,
      id: datatype.uuid(),
    },
    {
      ' $fragmentRefs': { VideoCard_video: true as const },
      __typename: 'Video' as const,
      id: datatype.uuid(),
    },
  ],
  title: lorem.word(),
  type,
});

const mockQuery = () => ({
  ' $refType': 'ChannelVideosShelves_channel' as const,
  login: lorem.word(),
  videoShelves: {
    edges: [
      {
        cursor: 0,
        node: mockShelf(),
      },
      {
        cursor: 1,
        node: {
          description: lorem.words(),
          id: datatype.uuid(),
          items: [
            {
              ' $fragmentRefs': { VideoCard_video: true as const },
              __typename: '%other' as const,
              id: datatype.uuid(),
            },
          ],
          title: lorem.word(),
          type: 'ALL_VIDEOS' as const,
        },
      },
    ],
    pageInfo: {
      hasNextPage: true,
    },
  },
});

describe('ChannelVideosShelves', () => {
  const setup = createShallowWrapperFactory(ChannelVideosShelvesBase, () => ({
    activeShelfType: null,
    channel: mockQuery(),
    relay: { refetch: jest.fn() } as any,
  }));

  const setupMount = createMountWrapperFactory(
    ChannelVideosShelvesBase,
    () => ({
      activeShelfType: null,
      channel: mockQuery(),
      relay: { refetch: jest.fn() } as any,
    }),
  );

  it('renders only the video shelf', () => {
    const { wrapper } = setup();
    expect(wrapper.find(InfiniteList).prop('length')).toEqual(1);
  });

  it('renders empty state', () => {
    const { wrapper } = setup({
      channel: {
        videoShelves: {
          edges: [],
        },
      },
    });

    expect(wrapper.find(ChannelEmptyState)).toExist();
  });

  it('renders channel list when there is an active shelf', () => {
    const { wrapper } = setup({ activeShelfType: 'ALL_VIDEOS' });
    expect(wrapper.find(InfiniteList)).not.toExist();
    expect(wrapper.find(VideoCard)).toHaveLength(2);
  });

  it('renders view all link only if type is a known type', () => {
    const { wrapper: first } = setupMount();
    expect(first.find(CoreLink)).toExist();

    const { wrapper: second } = setupMount({
      channel: {
        videoShelves: {
          edges: [
            {
              cursor: 1,
              node: mockShelf('GAME'),
            },
          ],
        },
      },
    });

    expect(second.find(CoreLink)).not.toExist();
  });
});
