import { graphql } from 'react-relay/hooks';
import type {
  ChannelVodsInitialProps,
  ChannelVodsPathParameters,
} from 'tachyon-page-utils';
import {
  channelVodsGetInitialProps,
  channelVodsPageviewTracking,
} from 'tachyon-page-utils';
import { pageHeadQueryVariables } from '../../growth';
import { ChannelLayout } from '../../layouts';
import type { PageWithQueryProps, TomorrowPage } from '../types';
import { ChannelVideosShelves } from './ChannelVideosShelves';
import type {
  ChannelVideosPage_QueryResponse,
  ChannelVideosPage_QueryVariables,
} from './__generated__/ChannelVideosPage_Query.graphql';

type ChannelVideosPageInitialProps = ChannelVodsInitialProps & {
  queryVariables: ChannelVideosPage_QueryVariables;
};

type ChannelVideosPageProps = PageWithQueryProps<
  ChannelVideosPage_QueryResponse,
  ChannelVideosPageInitialProps
>;

// istanbul ignore next: trivial
export const ChannelVideosPage: TomorrowPage<
  ChannelVideosPageInitialProps,
  ChannelVideosPageProps,
  ChannelVodsPathParameters
> = ({ activeShelfType, channel, loading, queryVariables }) => {
  return (
    <ChannelLayout
      loading={loading}
      login={queryVariables.login}
      user={channel}
    >
      {channel && (
        <ChannelVideosShelves
          activeShelfType={activeShelfType}
          channel={channel}
        />
      )}
    </ChannelLayout>
  );
};

ChannelVideosPage.displayName = 'ChannelVideosPage';
ChannelVideosPage.pageviewTracking = channelVodsPageviewTracking;
// TODO: verify non-js interactivity after dev
ChannelVideosPage.requiresJsForInteractivity = false;
ChannelVideosPage.handlesLoading = true;
ChannelVideosPage.getInitialProps = (ctx) =>
  channelVodsGetInitialProps(ctx, pageHeadQueryVariables(ctx));

ChannelVideosPage.query = graphql`
  query ChannelVideosPage_Query(
    $login: String!
    $first: Int = 10
    $cursor: Cursor
    $url: String!
  ) {
    channel: user(login: $login) {
      id
      login
      ...ChannelLayout_user
      ...ChannelVideosShelves_channel

      stream {
        id
      }
    }
    ...PageHead_query
  }
`;
