import { datatype, internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ChannelVideosShelves } from './ChannelVideosShelves';
import { ChannelVideosPage } from '.';

describe(ChannelVideosPage, () => {
  const setup = createShallowWrapperFactory(ChannelVideosPage, () => {
    const login = lorem.word().toLowerCase();

    return {
      ' $fragmentRefs': {
        PageHead_query: true,
      },
      activeShelfType: null,
      channel: {
        ' $fragmentRefs': {
          ChannelLayout_user: true,
          ChannelVideosShelves_channel: true,
        },
        id: datatype.uuid(),
        login,
        stream: null,
      },
      loading: false,
      queryVariables: {
        login,
        url: internet.url(),
      },
    };
  });

  it('renders correctly', () => {
    const { wrapper } = setup();
    expect(wrapper.find(ChannelVideosShelves)).toExist();
  });
});
