import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { reduceToNonNullNodes } from 'tachyon-utils';
import { Layout, Overflow } from 'twitch-core-ui';
import { ClipRowItem } from '../../../discovery';
import type { ClipList_clips } from './__generated__/ClipList_clips.graphql';

export type ClipListProps = {
  clips: ClipList_clips;
};

export const ClipListBase: FC<ClipListProps> = ({ clips }) => {
  const clipCards = reduceToNonNullNodes(clips.edges).map((c, idx) => (
    <Layout borderBottom borderTop={!idx} key={idx}>
      <ClipRowItem clip={c} interactionContent={`position_${idx}`} />
    </Layout>
  ));

  return <Layout overflow={Overflow.Scroll}>{clipCards}</Layout>;
};

ClipListBase.displayName = 'ChannelClipsBase';

export const ClipList = createFragmentContainer(ClipListBase, {
  clips: graphql`
    fragment ClipList_clips on ClipConnection {
      edges {
        node {
          ...ClipRowItem_clip
        }
      }
    }
  `,
});
