import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ClipRowItem } from '../../../discovery';
import { ClipListBase } from '.';

describe(ClipListBase, () => {
  const setup = createShallowWrapperFactory(ClipListBase, () => ({
    clips: {
      ' $refType': 'ClipList_clips',
      edges: [
        {
          node: {
            ' $fragmentRefs': { ClipRowItem_clip: true },
          },
        },
        {
          node: {
            ' $fragmentRefs': { ClipRowItem_clip: true },
          },
        },
        {
          node: {
            ' $fragmentRefs': { ClipRowItem_clip: true },
          },
        },
      ],
    },
  }));

  it('renders a card for each provided clip', () => {
    const { props, wrapper } = setup();

    expect(wrapper.find(ClipRowItem)).toHaveLength(props.clips.edges!.length);
  });
});
