import { internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { WebShareButton } from '../../../common';
import { ClipList } from '../ClipList';
import { ClipPanelBase } from '.';

let mockCanShare = true;

jest.mock('../../../common', () => ({
  ...jest.requireActual('../../../common'),
  canShare: () => mockCanShare,
}));

describe(ClipPanelBase, () => {
  const setup = createShallowWrapperFactory(ClipPanelBase, () => ({
    clip: {
      ' $refType': 'ClipPanel_clip',
      broadcaster: {
        clips: {
          ' $fragmentRefs': { ClipList_clips: true },
        },
        displayName: internet.userName(),
        login: internet.userName(),
        profileImageURL: internet.url(),
      },
      title: lorem.words(6),
    },
  }));

  beforeEach(() => {
    mockCanShare = true;
  });

  it('does not render the share feature if not supported', () => {
    mockCanShare = false;
    const { wrapper } = setup();
    expect(wrapper.find(WebShareButton)).not.toExist();
  });

  it('renders the share feature if supported', () => {
    const { wrapper } = setup();
    expect(wrapper.find(WebShareButton)).toExist();
  });

  it('renders a clip list when clips are returned', () => {
    const { wrapper } = setup();
    expect(wrapper.find(ClipList)).toExist();
  });

  it('does not render a clip list when no clips are returned', () => {
    const { wrapper } = setup({ clip: { broadcaster: { clips: null } } });
    expect(wrapper.find(ClipList)).not.toExist();
  });
});
