import { graphql } from 'react-relay/hooks';
import type { ClipInitialProps, ClipPathParameters } from 'tachyon-page-utils';
import {
  clipGetInitialProps,
  clipIsFound,
  clipIsNotFoundServerside,
  clipPageviewTracking,
} from 'tachyon-page-utils';
import { PulsarClipPlayer } from '../../Player';
import { pageHeadQueryVariables } from '../../growth';
import { NotFoundErrorLayout, Page, PlayerLayout } from '../../layouts';
import type { TomorrowPage } from '../types';
import { ClipPanel } from './ClipPanel';
import type { Clip_QueryResponse } from './__generated__/Clip_Query.graphql';

export type ClipProps = Clip_QueryResponse & ClipInitialProps;

export const Clip: TomorrowPage<
  ClipInitialProps,
  ClipProps,
  ClipPathParameters
> = ({ clip, login }) => {
  if (!clipIsFound(clip, login)) {
    return <NotFoundErrorLayout />;
  }

  return (
    <Page>
      <PlayerLayout player={<PulsarClipPlayer clip={clip} />}>
        <ClipPanel clip={clip} />
      </PlayerLayout>
    </Page>
  );
};

Clip.displayName = 'ClipPage';
Clip.getInitialProps = (ctx) =>
  clipGetInitialProps(ctx, pageHeadQueryVariables(ctx));
Clip.isNotFoundServerside = clipIsNotFoundServerside;
Clip.pageviewTracking = clipPageviewTracking;
Clip.totalCacheLife = 1800;
Clip.requiresJsForInteractivity = true;

Clip.query = graphql`
  query Clip_Query($slug: ID!, $url: String!) {
    clip(slug: $slug) {
      ...ClipPanel_clip
      ...ClipPlayer_clip
      title
      id
      broadcaster {
        id
        login
        displayName
        profileImageURL(width: 50)
        subscriptionProducts {
          id
        }
      }
      slug
      game {
        id
        name
      }
    }
    ...PageHead_query
  }
`;
