import { datatype, internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { NotFoundErrorLayout, PlayerLayout } from '../../layouts';
import { ClipPanel } from './ClipPanel';
import { Clip } from '.';

describe(Clip, () => {
  const setup = createShallowWrapperFactory(Clip, () => {
    const channelLogin = internet.userName();
    const slug = lorem.words(4);

    return {
      ' $fragmentRefs': {
        PageHead_query: true,
      },
      clip: {
        ' $fragmentRefs': {
          ClipPanel_clip: true,
          ClipPlayer_clip: true,
        },
        broadcaster: {
          displayName: channelLogin,
          id: datatype.uuid(),
          login: channelLogin,
          profileImageURL: internet.url(),
          subscriptionProducts: null,
        },
        game: {
          id: datatype.uuid(),
          name: lorem.words(4),
        },
        id: datatype.uuid(),
        slug,
        title: lorem.words(5),
      },
      login: channelLogin,
      queryVariables: {
        slug,
        url: internet.url(),
      },
    };
  });

  it('renders a Clip player when the Clip is found', () => {
    const { wrapper } = setup();

    expect(wrapper.find(PlayerLayout)).toExist();
    expect(wrapper.find(ClipPanel)).toExist();
  });

  it('renders a not found page when the Clip is not found', () => {
    const { wrapper } = setup({ clip: null });

    expect(wrapper.find(NotFoundErrorLayout)).toExist();
    expect(wrapper.find(PlayerLayout)).not.toExist();
  });
});
