import { createShallowWrapperFactory } from 'tachyon-test-utils';
import {
  ChannelList,
  GameCardCommon,
  NoChannelsLive,
} from '../../../discovery';
import { TopChannelsForGameBase } from '.';

describe(TopChannelsForGameBase, () => {
  const setup = createShallowWrapperFactory(TopChannelsForGameBase, () => ({
    gameAlias: 'World of Warcraft',
    query: {
      ' $fragmentRefs': { ActiveTagFilter_query: true },
      ' $refType': 'TopChannelsForGame_query',
      game: {
        ' $fragmentRefs': { GameCardCommon_game: true },
        displayName: 'World of Warcraft',
        name: 'World of Warcraft',
        streams: {
          edges: [
            {
              cursor: '1321',
              node: {
                ' $fragmentRefs': { DirectoryStreamCard_stream: true },
                id: '123',
              },
            },
          ],
        },
      },
    },
    relay: { refetch: jest.fn() } as any,
    tags: null,
  }));

  it('returns the No Channels UI when no channels are live', () => {
    const { wrapper } = setup({
      query: {
        game: {
          streams: {
            edges: [],
          },
        },
      },
    });

    expect(wrapper.find(NoChannelsLive)).toExist();
    expect(wrapper.find(ChannelList)).not.toExist();
  });

  it('returns the No Channels UI when streams are null', () => {
    const { wrapper } = setup({ query: { game: { streams: null } } });
    expect(wrapper.find(NoChannelsLive)).toExist();
    expect(wrapper.find(ChannelList)).not.toExist();
  });

  it('renders a channel list with the provided streams', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(ChannelList).prop('streams')).toHaveLength(
      props.query.game!.streams!.edges!.length,
    );
    expect(wrapper.find(GameCardCommon)).toExist();
  });
});
