/* tslint:disable */
/* eslint-disable */
// @ts-nocheck

import { ConcreteRequest } from "relay-runtime";
import { FragmentRefs } from "relay-runtime";
export type GameDirectory_QueryVariables = {
    gameAlias: string;
    channelsCount: number;
    cursor?: unknown | null;
    hasTagId: boolean;
    tagId: string;
    tags?: Array<string> | null;
    url: string;
};
export type GameDirectory_QueryResponse = {
    readonly game: {
        readonly name: string;
        readonly displayName: string;
    } | null;
    readonly " $fragmentRefs": FragmentRefs<"TopChannelsForGame_query" | "PageHead_query">;
};
export type GameDirectory_Query = {
    readonly response: GameDirectory_QueryResponse;
    readonly variables: GameDirectory_QueryVariables;
};



/*
query GameDirectory_Query(
  $gameAlias: String!
  $channelsCount: Int!
  $cursor: Cursor
  $hasTagId: Boolean!
  $tagId: ID!
  $tags: [String!]
  $url: String!
) {
  ...TopChannelsForGame_query
  game(name: $gameAlias) {
    name
    displayName
    id
  }
  ...PageHead_query
}

fragment ActiveTagFilter_query on Query {
  contentTag(id: $tagId) {
    ...TagLink_tag
    id
  }
}

fragment DirectoryStreamCard_stream on Stream {
  ...StreamCardCommon_stream
  broadcaster {
    login
    id
  }
}

fragment GameCardCommon_game on Game {
  name
  displayName
  viewersCount
  followersCount
  boxArtURL
  ...TagList_game
}

fragment PageHead_query on Query {
  urlMetadata(url: $url) {
    title
    metatags {
      name
      attributes {
        key
        value
      }
    }
    jsonld
    share {
      title
      text
      url
    }
  }
}

fragment StreamCardCommon_stream on Stream {
  id
  viewersCount
  previewImageURL
  type
  game {
    id
    name
  }
  broadcaster {
    id
    broadcastSettings {
      title
      id
    }
    login
    displayName
    profileImageURL(width: 50)
    hosting {
      id
    }
  }
  ...TagList_stream
}

fragment TagLink_tag on Tag {
  id
  tagName
  localizedDescription
  localizedName
}

fragment TagList_game on Game {
  gameTags: tags(limit: 10, tagType: CONTENT) {
    ...TagLink_tag
    id
  }
}

fragment TagList_stream on Stream {
  streamTags: tags {
    ...TagLink_tag
    id
  }
}

fragment TopChannelsForGame_query on Query {
  ...ActiveTagFilter_query @include(if: $hasTagId)
  game(name: $gameAlias) {
    name
    displayName
    ...GameCardCommon_game
    streams(first: $channelsCount, after: $cursor, tags: $tags) {
      edges {
        cursor
        node {
          id
          ...DirectoryStreamCard_stream
        }
      }
    }
    id
  }
}
*/

const node: ConcreteRequest = (function(){
var v0 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "channelsCount"
},
v1 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "cursor"
},
v2 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "gameAlias"
},
v3 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "hasTagId"
},
v4 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "tagId"
},
v5 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "tags"
},
v6 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "url"
},
v7 = [
  {
    "kind": "Variable",
    "name": "name",
    "variableName": "gameAlias"
  }
],
v8 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "name",
  "storageKey": null
},
v9 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "displayName",
  "storageKey": null
},
v10 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "viewersCount",
  "storageKey": null
},
v11 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "id",
  "storageKey": null
},
v12 = [
  (v11/*: any*/),
  {
    "alias": null,
    "args": null,
    "kind": "ScalarField",
    "name": "tagName",
    "storageKey": null
  },
  {
    "alias": null,
    "args": null,
    "kind": "ScalarField",
    "name": "localizedDescription",
    "storageKey": null
  },
  {
    "alias": null,
    "args": null,
    "kind": "ScalarField",
    "name": "localizedName",
    "storageKey": null
  }
],
v13 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "title",
  "storageKey": null
};
return {
  "fragment": {
    "argumentDefinitions": [
      (v0/*: any*/),
      (v1/*: any*/),
      (v2/*: any*/),
      (v3/*: any*/),
      (v4/*: any*/),
      (v5/*: any*/),
      (v6/*: any*/)
    ],
    "kind": "Fragment",
    "metadata": null,
    "name": "GameDirectory_Query",
    "selections": [
      {
        "alias": null,
        "args": (v7/*: any*/),
        "concreteType": "Game",
        "kind": "LinkedField",
        "name": "game",
        "plural": false,
        "selections": [
          (v8/*: any*/),
          (v9/*: any*/)
        ],
        "storageKey": null
      },
      {
        "args": null,
        "kind": "FragmentSpread",
        "name": "TopChannelsForGame_query"
      },
      {
        "args": null,
        "kind": "FragmentSpread",
        "name": "PageHead_query"
      }
    ],
    "type": "Query",
    "abstractKey": null
  },
  "kind": "Request",
  "operation": {
    "argumentDefinitions": [
      (v2/*: any*/),
      (v0/*: any*/),
      (v1/*: any*/),
      (v3/*: any*/),
      (v4/*: any*/),
      (v5/*: any*/),
      (v6/*: any*/)
    ],
    "kind": "Operation",
    "name": "GameDirectory_Query",
    "selections": [
      {
        "alias": null,
        "args": (v7/*: any*/),
        "concreteType": "Game",
        "kind": "LinkedField",
        "name": "game",
        "plural": false,
        "selections": [
          (v8/*: any*/),
          (v9/*: any*/),
          (v10/*: any*/),
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "followersCount",
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "boxArtURL",
            "storageKey": null
          },
          {
            "alias": "gameTags",
            "args": [
              {
                "kind": "Literal",
                "name": "limit",
                "value": 10
              },
              {
                "kind": "Literal",
                "name": "tagType",
                "value": "CONTENT"
              }
            ],
            "concreteType": "Tag",
            "kind": "LinkedField",
            "name": "tags",
            "plural": true,
            "selections": (v12/*: any*/),
            "storageKey": "tags(limit:10,tagType:\"CONTENT\")"
          },
          {
            "alias": null,
            "args": [
              {
                "kind": "Variable",
                "name": "after",
                "variableName": "cursor"
              },
              {
                "kind": "Variable",
                "name": "first",
                "variableName": "channelsCount"
              },
              {
                "kind": "Variable",
                "name": "tags",
                "variableName": "tags"
              }
            ],
            "concreteType": "StreamConnection",
            "kind": "LinkedField",
            "name": "streams",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "StreamEdge",
                "kind": "LinkedField",
                "name": "edges",
                "plural": true,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "cursor",
                    "storageKey": null
                  },
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "Stream",
                    "kind": "LinkedField",
                    "name": "node",
                    "plural": false,
                    "selections": [
                      (v11/*: any*/),
                      (v10/*: any*/),
                      {
                        "alias": null,
                        "args": null,
                        "kind": "ScalarField",
                        "name": "previewImageURL",
                        "storageKey": null
                      },
                      {
                        "alias": null,
                        "args": null,
                        "kind": "ScalarField",
                        "name": "type",
                        "storageKey": null
                      },
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "Game",
                        "kind": "LinkedField",
                        "name": "game",
                        "plural": false,
                        "selections": [
                          (v11/*: any*/),
                          (v8/*: any*/)
                        ],
                        "storageKey": null
                      },
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "User",
                        "kind": "LinkedField",
                        "name": "broadcaster",
                        "plural": false,
                        "selections": [
                          (v11/*: any*/),
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "BroadcastSettings",
                            "kind": "LinkedField",
                            "name": "broadcastSettings",
                            "plural": false,
                            "selections": [
                              (v13/*: any*/),
                              (v11/*: any*/)
                            ],
                            "storageKey": null
                          },
                          {
                            "alias": null,
                            "args": null,
                            "kind": "ScalarField",
                            "name": "login",
                            "storageKey": null
                          },
                          (v9/*: any*/),
                          {
                            "alias": null,
                            "args": [
                              {
                                "kind": "Literal",
                                "name": "width",
                                "value": 50
                              }
                            ],
                            "kind": "ScalarField",
                            "name": "profileImageURL",
                            "storageKey": "profileImageURL(width:50)"
                          },
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "User",
                            "kind": "LinkedField",
                            "name": "hosting",
                            "plural": false,
                            "selections": [
                              (v11/*: any*/)
                            ],
                            "storageKey": null
                          }
                        ],
                        "storageKey": null
                      },
                      {
                        "alias": "streamTags",
                        "args": null,
                        "concreteType": "Tag",
                        "kind": "LinkedField",
                        "name": "tags",
                        "plural": true,
                        "selections": (v12/*: any*/),
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          (v11/*: any*/)
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": [
          {
            "kind": "Variable",
            "name": "url",
            "variableName": "url"
          }
        ],
        "concreteType": "URLMetadata",
        "kind": "LinkedField",
        "name": "urlMetadata",
        "plural": false,
        "selections": [
          (v13/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "SEOMetatag",
            "kind": "LinkedField",
            "name": "metatags",
            "plural": true,
            "selections": [
              (v8/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "SEOMetatagAttribute",
                "kind": "LinkedField",
                "name": "attributes",
                "plural": true,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "key",
                    "storageKey": null
                  },
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "value",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "jsonld",
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "URLMetadataShare",
            "kind": "LinkedField",
            "name": "share",
            "plural": false,
            "selections": [
              (v13/*: any*/),
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "text",
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "url",
                "storageKey": null
              }
            ],
            "storageKey": null
          }
        ],
        "storageKey": null
      },
      {
        "condition": "hasTagId",
        "kind": "Condition",
        "passingValue": true,
        "selections": [
          {
            "alias": null,
            "args": [
              {
                "kind": "Variable",
                "name": "id",
                "variableName": "tagId"
              }
            ],
            "concreteType": "Tag",
            "kind": "LinkedField",
            "name": "contentTag",
            "plural": false,
            "selections": (v12/*: any*/),
            "storageKey": null
          }
        ]
      }
    ]
  },
  "params": {
    "cacheID": "650e7ee41d83f13d35e4cb4e9c955b7a",
    "id": null,
    "metadata": {},
    "name": "GameDirectory_Query",
    "operationKind": "query",
    "text": "query GameDirectory_Query(\n  $gameAlias: String!\n  $channelsCount: Int!\n  $cursor: Cursor\n  $hasTagId: Boolean!\n  $tagId: ID!\n  $tags: [String!]\n  $url: String!\n) {\n  ...TopChannelsForGame_query\n  game(name: $gameAlias) {\n    name\n    displayName\n    id\n  }\n  ...PageHead_query\n}\n\nfragment ActiveTagFilter_query on Query {\n  contentTag(id: $tagId) {\n    ...TagLink_tag\n    id\n  }\n}\n\nfragment DirectoryStreamCard_stream on Stream {\n  ...StreamCardCommon_stream\n  broadcaster {\n    login\n    id\n  }\n}\n\nfragment GameCardCommon_game on Game {\n  name\n  displayName\n  viewersCount\n  followersCount\n  boxArtURL\n  ...TagList_game\n}\n\nfragment PageHead_query on Query {\n  urlMetadata(url: $url) {\n    title\n    metatags {\n      name\n      attributes {\n        key\n        value\n      }\n    }\n    jsonld\n    share {\n      title\n      text\n      url\n    }\n  }\n}\n\nfragment StreamCardCommon_stream on Stream {\n  id\n  viewersCount\n  previewImageURL\n  type\n  game {\n    id\n    name\n  }\n  broadcaster {\n    id\n    broadcastSettings {\n      title\n      id\n    }\n    login\n    displayName\n    profileImageURL(width: 50)\n    hosting {\n      id\n    }\n  }\n  ...TagList_stream\n}\n\nfragment TagLink_tag on Tag {\n  id\n  tagName\n  localizedDescription\n  localizedName\n}\n\nfragment TagList_game on Game {\n  gameTags: tags(limit: 10, tagType: CONTENT) {\n    ...TagLink_tag\n    id\n  }\n}\n\nfragment TagList_stream on Stream {\n  streamTags: tags {\n    ...TagLink_tag\n    id\n  }\n}\n\nfragment TopChannelsForGame_query on Query {\n  ...ActiveTagFilter_query @include(if: $hasTagId)\n  game(name: $gameAlias) {\n    name\n    displayName\n    ...GameCardCommon_game\n    streams(first: $channelsCount, after: $cursor, tags: $tags) {\n      edges {\n        cursor\n        node {\n          id\n          ...DirectoryStreamCard_stream\n        }\n      }\n    }\n    id\n  }\n}\n"
  }
};
})();
(node as any).hash = 'cd5811802e96ee035da6d02da5651671';
export default node;
