import { graphql } from 'react-relay/hooks';
import type { GamePathParameters } from 'tachyon-page-utils';
import { gameGetInitialProps, gamePageviewTracking } from 'tachyon-page-utils';
import { CHANNELS_PAGE_SIZE } from '../../../config';
import type { TagQueryPathParameters } from '../../common';
import { getTagQueryVariables } from '../../common';
import { pageHeadQueryVariables } from '../../growth';
import { Page } from '../../layouts';
import type { TomorrowPage } from '../types';
import { TopChannelsForGame } from './TopChannelsForGame';
import type {
  GameDirectory_QueryResponse,
  GameDirectory_QueryVariables,
} from './__generated__/GameDirectory_Query.graphql';

type GameDirectoryPathParameters = GamePathParameters & TagQueryPathParameters;

type GameDirectoryInitialProps = {
  queryVariables: GameDirectory_QueryVariables;
};

export type GameDirectoryProps = GameDirectory_QueryResponse &
  GameDirectoryInitialProps;

// istanbul ignore next: trivial
export const GameDirectory: TomorrowPage<
  GameDirectoryInitialProps,
  GameDirectoryProps,
  GameDirectoryPathParameters
> = (props) => (
  <Page>
    <TopChannelsForGame
      gameAlias={props.queryVariables.gameAlias}
      query={props}
      tags={props.queryVariables.tags}
    />
  </Page>
);

GameDirectory.displayName = 'GameDirectory';
GameDirectory.pageviewTracking = gamePageviewTracking;
GameDirectory.requiresJsForInteractivity = false;

GameDirectory.query = graphql`
  query GameDirectory_Query(
    $gameAlias: String!
    $channelsCount: Int!
    $cursor: Cursor
    $hasTagId: Boolean!
    $tagId: ID!
    $tags: [String!]
    $url: String!
  ) {
    ...TopChannelsForGame_query
    game(name: $gameAlias) {
      name
      displayName
    }
    ...PageHead_query
  }
`;

// istanbul ignore next: trivial
GameDirectory.getInitialProps = (context) =>
  gameGetInitialProps(context, {
    ...pageHeadQueryVariables(context),
    ...getTagQueryVariables(context),
    channelsCount: CHANNELS_PAGE_SIZE,
    cursor: null,
  });
