import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ChannelList, NoChannelsLive } from '../../../discovery';
import { TopChannelsBase } from '.';

describe(TopChannelsBase, () => {
  const setup = createShallowWrapperFactory(TopChannelsBase, () => ({
    query: {
      ' $fragmentRefs': { ActiveTagFilter_query: true },
      ' $refType': 'TopChannels_query',
      streams: {
        edges: [
          {
            cursor: '1321',
            node: {
              ' $fragmentRefs': { DirectoryStreamCard_stream: true },
              id: '123',
            },
          },
        ],
      },
    },
    relay: { refetch: jest.fn() } as any,
    tags: null,
  }));

  it('returns the No Channels UI when no channels are live', () => {
    const { wrapper } = setup({
      query: {
        streams: {
          edges: [],
        },
      },
    });

    expect(wrapper.find(NoChannelsLive)).toExist();
    expect(wrapper.find(ChannelList)).not.toExist();
  });

  it('returns the No Channels UI when streams are null', () => {
    const { wrapper } = setup({ query: { streams: null } });
    expect(wrapper.find(NoChannelsLive)).toExist();
    expect(wrapper.find(ChannelList)).not.toExist();
  });

  it('renders a channel list with the provided streams', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(ChannelList).prop('streams')).toHaveLength(
      props.query.streams!.edges!.length,
    );
  });
});
