import { graphql } from 'react-relay/hooks';
import { defaultPageviewTracking } from 'tachyon-page-utils';
import { CHANNELS_PAGE_SIZE } from '../../../config';
import type { TagQueryPathParameters } from '../../common';
import { getTagQueryVariables } from '../../common';
import { pageHeadQueryVariables } from '../../growth';
import { Page } from '../../layouts';
import type { TomorrowPage } from '../types';
import { TopChannels } from './TopChannels';
import type {
  GameDirectoryAll_QueryResponse,
  GameDirectoryAll_QueryVariables,
} from './__generated__/GameDirectoryAll_Query.graphql';

type GameDirectoryAllInitialProps = {
  queryVariables: GameDirectoryAll_QueryVariables;
};

export type GameDirectoryAllProps = GameDirectoryAll_QueryResponse &
  GameDirectoryAllInitialProps;

// istanbul ignore next: trivial
export const GameDirectoryAll: TomorrowPage<
  GameDirectoryAllInitialProps,
  GameDirectoryAllProps,
  TagQueryPathParameters
> = (props) => (
  <Page>
    <TopChannels query={props} tags={props.queryVariables.tags} />
  </Page>
);

GameDirectoryAll.displayName = 'GameDirectoryAll';
GameDirectoryAll.pageviewTracking = defaultPageviewTracking;
GameDirectoryAll.requiresJsForInteractivity = false;

GameDirectoryAll.query = graphql`
  query GameDirectoryAll_Query(
    $channelsCount: Int!
    $cursor: Cursor
    $hasTagId: Boolean!
    $tagId: ID!
    $tags: [String!]
    $url: String!
  ) {
    ...TopChannels_query
    ...PageHead_query
  }
`;

GameDirectoryAll.getInitialProps = (context) => ({
  queryVariables: {
    ...pageHeadQueryVariables(context),
    ...getTagQueryVariables(context),
    channelsCount: CHANNELS_PAGE_SIZE,
    cursor: null,
  },
});
