import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { GameListBase, ScGameList } from '.';

describe(GameListBase, () => {
  const setup = createShallowWrapperFactory(GameListBase, () => ({
    query: {
      ' $fragmentRefs': { ActiveTagFilter_query: true },
      ' $refType': 'GameList_query',
      games: {
        edges: [
          {
            cursor: '1321',
            node: {
              ' $fragmentRefs': { DirectoryGameCard_game: true },
              id: '123',
            },
          },
        ],
      },
    },
    relay: { refetch: jest.fn() } as any,
    tags: null,
  }));

  it('renders styled components', () => {
    const { wrapper } = setup();
    expect(wrapper.find(ScGameList)).toExist();
  });
});
