import { graphql } from 'react-relay/hooks';
import { defaultPageviewTracking } from 'tachyon-page-utils';
import { GAMES_PAGE_SIZE } from '../../../config';
import type { TagQueryPathParameters } from '../../common';
import { getTagQueryVariables } from '../../common';
import { pageHeadQueryVariables } from '../../growth';
import { Page } from '../../layouts';
import type { TomorrowPage } from '../types';
import { GameList } from './GameList';
import type {
  GamesDirectory_QueryResponse,
  GamesDirectory_QueryVariables,
} from './__generated__/GamesDirectory_Query.graphql';

type GamesDirectoryInitialProps = {
  queryVariables: GamesDirectory_QueryVariables;
};

export type GamesDirectoryProps = GamesDirectory_QueryResponse &
  GamesDirectoryInitialProps;

// istanbul ignore next: trivial
export const GamesDirectory: TomorrowPage<
  GamesDirectoryInitialProps,
  GamesDirectoryProps,
  TagQueryPathParameters
> = (props) => (
  <Page>
    <GameList query={props} tags={props.queryVariables.tags} />
  </Page>
);

GamesDirectory.displayName = 'GamesDirectory';
GamesDirectory.pageviewTracking = defaultPageviewTracking;
GamesDirectory.requiresJsForInteractivity = false;

GamesDirectory.query = graphql`
  query GamesDirectory_Query(
    $gamesCount: Int!
    $cursor: Cursor
    $hasTagId: Boolean!
    $tagId: ID!
    $tags: [String!]
    $url: String!
  ) {
    ...GameList_query
    ...PageHead_query
  }
`;

// istanbul ignore next: trivial
GamesDirectory.getInitialProps = (context) => ({
  queryVariables: {
    ...pageHeadQueryVariables(context),
    ...getTagQueryVariables(context),
    cursor: null,
    gamesCount: GAMES_PAGE_SIZE,
  },
});
