import Faker from 'faker';
import {
  ContentType,
  mockRecommendationTrackingParams,
} from 'tachyon-discovery';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { GameCardCommon } from '../../../../discovery';
import { ShelfGameCardBase } from '.';

const mockOnRecommendationItemClick = jest.fn();
const mockOnRecommendationItemDisplay = jest.fn();

jest.mock('tachyon-discovery', () => ({
  ...jest.requireActual('tachyon-discovery'),
  useDiscoveryTracking: () => ({
    onRecommendationItemClick: mockOnRecommendationItemClick,
    onRecommendationItemDisplay: mockOnRecommendationItemDisplay,
  }),
}));

describe(ShelfGameCardBase, () => {
  const setup = createShallowWrapperFactory(ShelfGameCardBase, () => ({
    game: {
      ' $fragmentRefs': { GameCardCommon_game: true },
      ' $refType': 'ShelfGameCard_game',
      id: Faker.datatype.uuid(),
      name: 'World of Warcraft',
    },
    impressionListener: {
      registerImpressionCallback: jest.fn(),
      unregisterImpressionCallback: jest.fn(),
    },
    shelfTracking: mockRecommendationTrackingParams(),
  }));

  it('reports an ItemClick event when clicked', () => {
    const { props, wrapper } = setup();
    wrapper.find(GameCardCommon).simulate('click');

    expect(mockOnRecommendationItemClick).toHaveBeenCalledTimes(1);
    expect(mockOnRecommendationItemClick).toHaveBeenCalledWith({
      ...props.shelfTracking,
      contentType: ContentType.Game,
      itemID: props.game.id,
      itemTrackingID: props.shelfTracking.itemTrackingID,
      modelTrackingID: props.shelfTracking.itemTrackingID,
    });
  });
});
