import {
  ContentType,
  mockRecommendationTrackingParams,
} from 'tachyon-discovery';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { StreamCardCommon } from '../../../../discovery';
import type { ShelfStreamCard_stream } from './__generated__/ShelfStreamCard_stream.graphql';
import { ShelfStreamCardBase } from '.';

const mockOnRecommendationItemClick = jest.fn();
const mockOnRecommendationItemDisplay = jest.fn();

jest.mock('tachyon-discovery', () => ({
  ...jest.requireActual('tachyon-discovery'),
  useDiscoveryTracking: () => ({
    onRecommendationItemClick: mockOnRecommendationItemClick,
    onRecommendationItemDisplay: mockOnRecommendationItemDisplay,
  }),
}));

describe(ShelfStreamCardBase, () => {
  const setup = createShallowWrapperFactory(ShelfStreamCardBase, () => ({
    impressionListener: {
      registerImpressionCallback: jest.fn(),
      unregisterImpressionCallback: jest.fn(),
    },
    shelfTracking: mockRecommendationTrackingParams(),
    stream: mockShelfStreamCardQuery(),
  }));

  beforeEach(() => {
    jest.resetAllMocks();
  });

  it('renders a linked card when given correct props', () => {
    const { wrapper } = setup();
    expect(wrapper.find(StreamCardCommon)).toExist();
  });

  it('reports an ItemClick event when clicked', () => {
    const { props, wrapper } = setup();
    wrapper.find(StreamCardCommon).simulate('click');

    expect(mockOnRecommendationItemClick).toHaveBeenCalledTimes(1);
    expect(mockOnRecommendationItemClick).toHaveBeenCalledWith({
      ...props.shelfTracking,
      contentType: ContentType.LiveStream,
      itemID: props.stream.id,
      itemTrackingID: props.shelfTracking.itemTrackingID,
      modelTrackingID: props.shelfTracking.itemTrackingID,
    });
  });
});

function mockShelfStreamCardQuery(): ShelfStreamCard_stream {
  return {
    ' $fragmentRefs': { StreamCardCommon_stream: true },
    ' $refType': 'ShelfStreamCard_stream',
    broadcaster: {
      login: 'esfandtv',
    },
    id: '3569272',
  };
}
