import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { SVG, SVGAsset } from 'twitch-core-ui';
import { Shelf } from './Shelf';
import type { RecommendationShelves_query } from './__generated__/RecommendationShelves_query.graphql';
import { RecommendationShelvesBase } from '.';

describe(RecommendationShelvesBase, () => {
  function mockShelvesQuery(options?: {
    noEdges: boolean;
  }): RecommendationShelves_query {
    return {
      ' $refType': 'RecommendationShelves_query',
      shelves: {
        edges: options?.noEdges
          ? null
          : [
              {
                node: {
                  ' $fragmentRefs': { Shelf_shelf: true },
                },
              },
              {
                node: {
                  ' $fragmentRefs': { Shelf_shelf: true },
                },
              },
              {
                node: {
                  ' $fragmentRefs': { Shelf_shelf: true },
                },
              },
            ],
      },
    };
  }

  const setup = createShallowWrapperFactory(RecommendationShelvesBase, () => ({
    query: mockShelvesQuery(),
  }));

  it('renders page error if there are no shelves', () => {
    const { wrapper } = setup({
      query: mockShelvesQuery({
        noEdges: true,
      }),
    });

    expect(wrapper.find(SVG).props().asset).toBe(SVGAsset.DeadGlitch);
  });

  it('correctly renders all valid shelves', () => {
    const { wrapper } = setup();

    expect(wrapper.find(Shelf)).toHaveLength(3);
  });
});
