import type { IsolateGqlUnionType } from 'tachyon-type-library';
import type { Shelf_shelf } from './Shelf';
import type { ShelfGameCard_game } from './ShelfGameCard';
import type { ShelfStreamCard_stream } from './ShelfStreamCard';

type FilteredShelfEdges = NonNullable<Shelf_shelf['content']['edges']>;
type ShelfNode = FilteredShelfEdges[0]['node'];
type ShelfGame = IsolateGqlUnionType<'Game', ShelfNode>;
type ShelfStream = IsolateGqlUnionType<'Stream', ShelfNode>;

type RenderableStream = NonNullable<ShelfStreamCard_stream> & {
  broadcaster: NonNullable<ShelfStreamCard_stream['broadcaster']>;
};

type RenderableGame = NonNullable<ShelfGameCard_game>;

export function isStreamRenderable(
  stream: ShelfStream | ShelfStreamCard_stream,
): stream is RenderableStream {
  return !!stream.broadcaster;
}

function isGameRenderable(
  _game: ShelfGame | ShelfGameCard_game,
): _game is RenderableGame {
  // Game will always render
  return true;
}

export function filterShelfContent(shelf: Shelf_shelf): FilteredShelfEdges {
  if (!shelf.content.edges) {
    return [];
  }

  const { edges } = shelf.content;
  const filteredEdges = edges.filter((edge) => {
    if (!edge.node) {
      return false;
    } else if (edge.node.__typename === 'Stream') {
      return isStreamRenderable(edge.node);
    } else if (edge.node.__typename === 'Game') {
      return isGameRenderable(edge.node);
    }
    return false;
  });

  return filteredEdges;
}
