import { graphql } from 'react-relay/hooks';
import { defaultPageviewTracking } from 'tachyon-page-utils';
import { uniqueIDGenerator } from 'tachyon-utils';
import { RECS_QUERY_PLATFORM } from '../../../config';
import { pageHeadQueryVariables } from '../../growth';
import { Page } from '../../layouts';
import type { PageWithQueryProps, TomorrowPage } from '../types';
import { RecommendationShelves } from './RecommendationShelves';
import type {
  Homepage_QueryResponse,
  Homepage_QueryVariables,
} from './__generated__/Homepage_Query.graphql';

export const RECOMMENDATION_ITEMS_PER_ROW = 8;
export const RECOMMENDATION_NUM_OF_SHELVES = 8;

type HomepageInitialProps = {
  queryVariables: Homepage_QueryVariables;
};

export type HomepageProps = PageWithQueryProps<
  Homepage_QueryResponse,
  HomepageInitialProps
>;

// istanbul ignore next: trivial
export const Homepage: TomorrowPage<HomepageInitialProps, HomepageProps> = ({
  loading,
  ...props
}) => {
  return (
    <Page loading={loading}>
      <RecommendationShelves query={props} />
    </Page>
  );
};

Homepage.displayName = 'Homepage';
Homepage.totalCacheLife = 0;
Homepage.pageviewTracking = defaultPageviewTracking;
Homepage.requiresJsForInteractivity = false;
Homepage.handlesLoading = true;

Homepage.query = graphql`
  query Homepage_Query(
    $requestID: String!
    $platform: String!
    $limit: Int!
    $itemsPerRow: Int!
    $url: String!
  ) {
    ...RecommendationShelves_query
    ...PageHead_query
  }
`;

// istanbul ignore next: trivial
Homepage.getInitialProps = (ctx) => ({
  queryVariables: {
    ...pageHeadQueryVariables(ctx),
    itemsPerRow: RECOMMENDATION_ITEMS_PER_ROW,
    limit: RECOMMENDATION_NUM_OF_SHELVES,
    platform: RECS_QUERY_PLATFORM,
    // The Homepage query will always rerun and we will never serve from the Relay cache because the
    // requestID is regenerated each time next's router selects this page. This causes this page to
    // behave different than all the other pages.
    requestID: uniqueIDGenerator(16),
  },
});
