import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { GlowErrorCarSvg } from 'tachyon-more-ui';
import {
  AlignItems,
  CoreText,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  TextAlign,
  Title,
} from 'twitch-core-ui';

export const ReportWizardError: FC = () => {
  const { formatMessage } = useIntl();
  return (
    <Layout
      alignItems={AlignItems.Center}
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      fullHeight
      fullWidth
      justifyContent={JustifyContent.Center}
      padding={2}
      textAlign={TextAlign.Center}
    >
      <Layout maxWidth="15rem">
        <GlowErrorCarSvg />
      </Layout>
      <Layout margin={{ bottom: 1 }}>
        <Title>
          {formatMessage('Something went wrong', 'ReportWizardError')}
        </Title>
      </Layout>
      <CoreText>
        {formatMessage(
          'There was an error retrieving report wizard content. Please try again later.',
          'ReportWizardError',
        )}
      </CoreText>
    </Layout>
  );
};

ReportWizardError.displayName = 'ReportWizardError';
