import { GlowErrorCarSvg } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText, Title } from 'twitch-core-ui';
import { ReportWizardError } from '.';

const setup = createShallowWrapperFactory(ReportWizardError);

describe('ReportWizardError Component', () => {
  it('renders as expected with all its elements', () => {
    const { wrapper } = setup();
    expect(wrapper.find(GlowErrorCarSvg)).toExist();

    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('Something went wrong');

    expect(wrapper.find(CoreText)).toExist();
    expect(wrapper.find(CoreText).text()).toEqual(
      'There was an error retrieving report wizard content. Please try again later.',
    );
  });
});
