import { useContext } from 'react';
import type { FC } from 'react';
import {
  Confirmation,
  Content,
  DeadEnd,
  Description,
  DetailedReason,
  Form,
  NetzDG,
  Reason,
  ReportWizardStep,
  reportWizardContext,
} from 'tachyon-report-wizard';

export const WizardComponent: FC = () => {
  const { currentStep, reportSubmissionSuccess } =
    useContext(reportWizardContext);
  if (reportSubmissionSuccess) {
    return <Confirmation />;
  }

  return (
    <Form>
      {(() => {
        switch (currentStep) {
          case ReportWizardStep.DetailedReason:
            return <DetailedReason />;
          case ReportWizardStep.Reason:
            return <Reason />;
          case ReportWizardStep.Description:
            return <Description />;
          case ReportWizardStep.NetzDG:
            return <NetzDG />;
          case ReportWizardStep.DeadEnd:
            return <DeadEnd />;
          case ReportWizardStep.Content:
          default:
            return <Content />;
        }
      })()}
    </Form>
  );
};

WizardComponent.displayName = 'WizardComponent';
