import {
  Confirmation,
  Content,
  DeadEnd,
  Description,
  DetailedReason,
  NetzDG,
  Reason,
  ReportWizardStep,
  mockReportWizardContext,
} from 'tachyon-report-wizard';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { WizardComponent } from '.';

const setup = createMountWrapperFactory(WizardComponent);

describe(WizardComponent, () => {
  it('renders Confirmation card when report was successfully submitted', () => {
    const { wrapper } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({ reportSubmissionSuccess: true }),
      ],
    });
    expect(wrapper.find(Confirmation)).toExist();
  });

  it('renders Content card when context provides Content as current step', () => {
    const { wrapper } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({ currentStep: ReportWizardStep.Content }),
      ],
    });

    expect(wrapper.find(Content)).toExist();
  });

  it('renders DetailedReason card when context provides DetailedReason as current step', () => {
    const { wrapper } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({
          currentStep: ReportWizardStep.DetailedReason,
        }),
      ],
    });

    expect(wrapper.find(DetailedReason)).toExist();
  });

  it('renders Reason card when context provides Reason as current step', () => {
    const { wrapper } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({ currentStep: ReportWizardStep.Reason }),
      ],
    });

    expect(wrapper.find(Reason)).toExist();
  });

  it('renders Description card when context provides Description as current step', () => {
    const { wrapper } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({ currentStep: ReportWizardStep.Description }),
      ],
    });

    expect(wrapper.find(Description)).toExist();
  });

  it('renders NetzDG card when context provides NetzDG as current step', () => {
    const { wrapper } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({ currentStep: ReportWizardStep.NetzDG }),
      ],
    });

    expect(wrapper.find(NetzDG)).toExist();
  });

  it('renders DeadEnd card when context provides DeadEnd as current step', () => {
    const { wrapper } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({ currentStep: ReportWizardStep.DeadEnd }),
      ],
    });

    expect(wrapper.find(DeadEnd)).toExist();
  });
});
