import type { TachyonPageContext } from 'tachyon-next-types';
import { channelPathGetInitialProps } from 'tachyon-page-utils';
import type { ChannelPathParameters } from 'tachyon-page-utils';
import type { ReportContentType } from 'tachyon-report-wizard';
import { flattenHeaderOrParam, uniqueIDGenerator } from 'tachyon-utils';
import { pageHeadQueryVariables } from '../../growth';
import type { ReportWizardPage_QueryVariables } from './__generated__/ReportWizardPage_Query.graphql';

// all query params
export const CHANNEL_ID_KEY = 'channel-id';
export const COLLECTION_ID_KEY = 'collection-id';
export const CONTENT_ID_KEY = 'content-id';
export const CONTENT_TYPE_KEY = 'content-type';
export const LIVE_UP_MESSAGE_KEY = 'live-up-message';
export const MEDIA_TIMESTAMP_KEY = 'media-timestamp';
export const IS_EMBED_KEY = 'is-embed';
export const SQUAD_ID_KEY = 'squad-id';
export const VOD_ID_KEY = 'vod-id';

export enum ReportSubmitStatus {
  Unsubmitted,
  Success,
  MutationError,
}

export function reportWizardGetInitialProps<
  Context extends TachyonPageContext<ChannelPathParameters>,
>(
  context: Context,
): {
  queryVariables: ReportWizardPage_QueryVariables;
} {
  // we plan to one day support multiple content types in url params, but as of now only support one
  const contentType = flattenHeaderOrParam(context.query[CONTENT_TYPE_KEY]);

  return channelPathGetInitialProps(context, {
    // `url` from pagehead is also used in report wizard query
    ...pageHeadQueryVariables(context),
    content: contentType ? [contentType as ReportContentType] : undefined,
    reportSessionID: uniqueIDGenerator(),
  });
}
