import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { RemSVG } from 'tachyon-more-ui';
import {
  AlignItems,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  JustifyContent,
  Layout,
  Position,
  SVGAsset,
  SVGType,
  TextAlign,
  TextType,
} from 'twitch-core-ui';

/* istanbul ignore next: trivial */
export const NoResultsFoundPage: FC = () => {
  const { formatMessage } = useIntl();

  return (
    <Layout
      alignItems={AlignItems.Center}
      attachBottom
      attachLeft
      attachRight
      attachTop
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      justifyContent={JustifyContent.Center}
      margin={{ top: 5 }}
      position={Position.Absolute}
      textAlign={TextAlign.Center}
    >
      <RemSVG
        asset={SVGAsset.DeadGlitch}
        heightRem={12}
        type={SVGType.Brand}
        widthRem={12}
      />
      <CoreText type={TextType.H2}>
        {formatMessage('Booooo :( no results found', 'NoResultsError')}
      </CoreText>
      <Layout padding={{ top: 1 }}>
        <CoreText fontSize={FontSize.Size5}>
          {formatMessage('Please try a different keyword', 'NoResultsError')}
        </CoreText>
      </Layout>
    </Layout>
  );
};
NoResultsFoundPage.displayName = 'NoResultsFoundPage';
