import { StreamTypeIndicator } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import {
  Aspect,
  Avatar,
  CoreText,
  FontWeight,
  SVG,
  SVGAsset,
} from 'twitch-core-ui';
import { SearchItemBase } from '.';

const mockOnSearchSuggestionClick = jest.fn();
const mockOnSearchSuggestionDisplay = jest.fn();
jest.mock('tachyon-discovery', () => ({
  ...jest.requireActual('tachyon-discovery'),
  useDiscoveryTracking: () => ({
    onSearchSuggestionClick: mockOnSearchSuggestionClick,
    onSearchSuggestionDisplay: mockOnSearchSuggestionDisplay,
  }),
}));

describe('SearchItem', () => {
  const text = 'Test Item';
  const testURL = 'test.url';
  const testLogin = 'testuser';

  const setup = createShallowWrapperFactory(SearchItemBase, () => ({
    impressionListener: {
      registerImpressionCallback: jest.fn(),
      unregisterImpressionCallback: jest.fn(),
    },
    onClick: jest.fn(),
    onDisplay: jest.fn(),
    suggestion: null,
    text: 'Test Item',
  }));

  it('renders category suggestion items', () => {
    const { wrapper } = setup({
      suggestion: {
        __typename: 'SearchSuggestionCategory',
        boxArtURL: testURL,
        game: {
          name: 'test game',
        },
      },
    });

    expect(wrapper.find(Aspect).childAt(0).props()).toMatchObject({
      alt: text,
      src: testURL,
    });
  });

  it('renders unverified channel suggestion items', () => {
    const { wrapper } = setup({
      suggestion: {
        __typename: 'SearchSuggestionChannel',
        isVerified: false,
        login: testLogin,
        profileImageURL: testURL,
      },
    });

    expect(wrapper.find(Avatar).props()).toMatchObject({
      alt: text,
      src: testURL,
      userLogin: testLogin,
    });
    expect(wrapper.find(StreamTypeIndicator)).toExist();
    expect(wrapper.find(SVG)).not.toExist();
  });

  it('renders verified channel suggestion items', () => {
    const { wrapper } = setup({
      suggestion: {
        __typename: 'SearchSuggestionChannel',
        isVerified: true,
        login: testLogin,
        profileImageURL: testURL,
      },
    });

    expect(wrapper.find(SVG).prop('asset')).toEqual(SVGAsset.Verified);
  });

  it('renders text only suggestion items', () => {
    const { wrapper } = setup({
      suggestion: null,
    });

    expect(wrapper.find(SVG).prop('asset')).toEqual(SVGAsset.NavSearch);
    expect(wrapper.find(CoreText).prop('fontWeight')).toEqual(
      FontWeight.Regular,
    );
  });
});
