import { datatype, internet, lorem } from 'faker';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { CoreLink, CoreText } from 'twitch-core-ui';
import { SearchCategoryCardBase } from '.';

jest.mock('../../../../common', () => ({
  GameTagList: jest.fn(() => <div />),
}));

describe('SearchCategoryCard', () => {
  const setup = createMountWrapperFactory(SearchCategoryCardBase, () => ({
    game: {
      ' $fragmentRefs': { TagList_game: true },
      ' $refType': 'SearchCategoryCard_game',
      boxArtURL: internet.url(),
      displayName: lorem.word(),
      name: lorem.word(),
      viewersCount: datatype.number(),
    },
    impressionListener: {
      registerImpressionCallback: jest.fn(),
      unregisterImpressionCallback: jest.fn(),
    },
    onClick: jest.fn(),
    onDisplay: jest.fn(),
  }));

  it('renders with 0 viewer count', () => {
    const { props, wrapper } = setup({ game: { viewersCount: 0 } });
    expect(wrapper.find(CoreText)).toHaveLength(2);
    expect(
      props.impressionListener.registerImpressionCallback,
    ).toHaveBeenCalled();
  });

  it('calls onClick when the CoreLink is clicked', () => {
    const { props, wrapper } = setup();
    wrapper.find(CoreLink).prop('onClick')!({} as any);

    expect(props.onClick).toHaveBeenCalled();
  });
});
