import { datatype } from 'faker';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { CoreLink } from 'twitch-core-ui';
import { SearchOfflineChannel } from '../../SearchOfflineChannel';
import { SearchStreamCard } from '../../SearchStreamCard';
import { SearchChannelCardBase } from '.';

jest.mock('../../SearchStreamCard', () => ({
  SearchStreamCard: jest.fn(() => <div />),
}));

jest.mock('../../SearchOfflineChannel', () => ({
  SearchOfflineChannel: jest.fn(() => <div />),
}));

describe('SearchChannelCard', () => {
  const setup = createMountWrapperFactory(SearchChannelCardBase, () => ({
    channel: {
      ' $fragmentRefs': { SearchOfflineChannel_channel: true },
      ' $refType': 'SearchChannelCard_channel',
      id: datatype.uuid(),
      login: 'foo',
      roles: { isPartner: false },
      stream: null,
    },
    impressionListener: {
      registerImpressionCallback: jest.fn(),
      unregisterImpressionCallback: jest.fn(),
    },
    onClick: jest.fn(),
    onDisplay: jest.fn(),
  }));

  it('renders an offline card if stream is null', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(SearchOfflineChannel)).toExist();
    expect(
      props.impressionListener.registerImpressionCallback,
    ).toHaveBeenCalled();
  });

  it('renders a stream card if stream is null', () => {
    const { wrapper } = setup({
      channel: {
        stream: {
          ' $fragmentRefs': { SearchStreamCard_stream: true },
          id: datatype.uuid(),
        },
      },
    });
    expect(wrapper.find(SearchStreamCard)).toExist();
  });

  it('calls onClick when the CoreLink is clicked', () => {
    const { props, wrapper } = setup();
    wrapper.find(CoreLink).prop('onClick')!({} as any);

    expect(props.onClick).toHaveBeenCalledWith(false);
  });
});
