import { datatype, internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { SearchContentChannelName } from '../../SearchContentChannelName';
import { SearchRelatedLiveChannelsBase } from '.';

function mockStreamData() {
  return {
    broadcaster: {
      broadcastSettings: {
        id: datatype.uuid(),
        title: lorem.word(),
      },
      displayName: lorem.word(),
      id: datatype.uuid(),
      login: lorem.word(),
      roles: {
        isPartner: false,
      },
    },
    game: {
      displayName: lorem.word(),
      id: datatype.uuid(),
      name: lorem.word(),
    },
    id: datatype.uuid(),
    previewImageURL: internet.url(),
    viewersCount: datatype.number(),
  };
}

describe('SearchRelatedLiveChannels', () => {
  const setup = createShallowWrapperFactory(
    SearchRelatedLiveChannelsBase,
    () => ({
      channels: {
        ' $refType': 'SearchRelatedLiveChannels_channels',
        items: [
          {
            id: datatype.uuid(),
            stream: mockStreamData(),
          },
        ],
      },
      searchTerm: lorem.word(),
    }),
  );

  it('renders normally', () => {
    const { wrapper } = setup();
    expect(wrapper.find(SearchContentChannelName)).toExist();
    expect(wrapper.find(CoreText)).toHaveLength(3);
  });

  it('skips rendering channel name without broadcaster', () => {
    const { wrapper } = setup({
      channels: {
        items: [
          {
            id: datatype.uuid(),
            stream: {
              ...mockStreamData(),
              broadcaster: null,
            },
          },
        ],
      },
    });

    expect(wrapper.find(SearchContentChannelName)).not.toExist();
  });

  it('skips rendering game name without a game', () => {
    const { wrapper } = setup({
      channels: {
        items: [
          {
            id: datatype.uuid(),
            stream: {
              ...mockStreamData(),
              game: null,
            },
          },
        ],
      },
    });

    expect(wrapper.find(CoreText)).toHaveLength(2);
  });

  it('skips rendering viewer count without a viewersCount', () => {
    const { wrapper } = setup({
      channels: {
        items: [
          {
            id: datatype.uuid(),
            stream: {
              ...mockStreamData(),
              viewersCount: null,
            },
          },
        ],
      },
    });

    expect(wrapper.find(CoreText)).toHaveLength(2);
  });
});
