import { datatype, internet, lorem } from 'faker';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { CoreText, SVGAsset } from 'twitch-core-ui';
import { SearchVideoCardBase } from '.';

describe('SearchVideoCard', () => {
  const setup = createMountWrapperFactory(SearchVideoCardBase, () => ({
    impressionListener: {
      registerImpressionCallback: jest.fn(),
      unregisterImpressionCallback: jest.fn(),
    },
    onClick: jest.fn(),
    onDisplay: jest.fn(),
    video: {
      ' $refType': 'SearchVideoCard_video',
      game: {
        displayName: lorem.word(),
        id: datatype.uuid(),
        name: lorem.word(),
      },
      id: datatype.uuid(),
      lengthSeconds: 1000,
      owner: {
        displayName: lorem.word(),
        id: datatype.uuid(),
        login: lorem.word(),
        roles: null,
      },
      previewThumbnailURL: internet.url(),
      publishedAt: '2020-08-01T17:00:00.000Z',
      title: lorem.word(),
      viewCount: null,
    },
  }));

  it('renders view count with 0 viewers', () => {
    const { props, wrapper } = setup({ video: { viewCount: 0 } });
    expect(wrapper.find(CoreText).at(4).html()).toContain('view');
    expect(
      props.impressionListener.registerImpressionCallback,
    ).toHaveBeenCalled();
  });

  it('renders partner badge if user is partnered', () => {
    const { wrapper } = setup({
      video: {
        owner: {
          roles: { isPartner: true },
        },
      },
    });
    expect(wrapper.find({ asset: SVGAsset.Verified })).toExist();
  });
});
