import type { FC } from 'react';
import { RemSVG } from 'tachyon-more-ui';
import {
  AlignItems,
  CoreText,
  Display,
  Layout,
  SVGAsset,
  SVGType,
  TextType,
} from 'twitch-core-ui';

export interface SearchContentChannelNameProps {
  displayName: string | null;
  isPartner: boolean | null | undefined;
}

// istanbul ignore next: trivial
export const SearchContentChannelName: FC<SearchContentChannelNameProps> = ({
  displayName,
  isPartner,
}) => (
  <Layout alignItems={AlignItems.Center} display={Display.Flex}>
    <CoreText ellipsis type={TextType.H4}>
      {displayName}
    </CoreText>
    {isPartner && (
      <Layout padding={{ left: 0.5 }}>
        <RemSVG
          asset={SVGAsset.Verified}
          heightRem={1.5}
          type={SVGType.Brand}
          widthRem={1.5}
        />
      </Layout>
    )}
  </Layout>
);

SearchContentChannelName.displayName = 'SearchContentChannelName';
