import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import type { CoreLinkProps } from 'twitch-core-ui';
import {
  Color,
  CoreLink,
  CoreText,
  Display,
  FontSize,
  FontWeight,
  JustifyContent,
  Layout,
  TextTransform,
} from 'twitch-core-ui';

type SearchContentLabelProps = CoreLinkProps & {
  label: string;
};

// istanbul ignore next: trivial
export const SearchContentLabel: FC<SearchContentLabelProps> = ({
  label,
  ...props
}) => {
  const { formatMessage } = useIntl();
  return (
    <Layout
      display={Display.Flex}
      fontSize={FontSize.Size5}
      fontWeight={FontWeight.SemiBold}
      justifyContent={JustifyContent.Between}
      margin={{ bottom: 1 }}
    >
      <CoreText color={Color.Alt2} transform={TextTransform.Uppercase}>
        {label}
      </CoreText>
      <CoreLink {...props}>
        <CoreText color={Color.Link} transform={TextTransform.Uppercase}>
          {formatMessage('View All', 'SearchResults')}
        </CoreText>
      </CoreLink>
    </Layout>
  );
};

SearchContentLabel.displayName = 'SearchContentLabel';
