import { internet } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { SearchOfflineChannelBase } from '.';

describe('SearchOfflineChannel', () => {
  const setup = createShallowWrapperFactory(SearchOfflineChannelBase, () => ({
    channel: {
      ' $refType': 'SearchOfflineChannel_channel',
      displayName: 'foo',
      followers: { totalCount: 100 },
      lastBroadcast: { startedAt: 'yesterday' },
      login: 'foo',
      profileImageURL: internet.url(),
    },
  }));

  it('renders last broadcast time and follower count', () => {
    const { wrapper } = setup();
    expect(wrapper.find(CoreText)).toHaveLength(2);
  });

  it('skips rendering last broadcast time with no lastBroadcast field in response', () => {
    const { wrapper } = setup({
      channel: {
        followers: { totalCount: 100 },
        lastBroadcast: null,
      },
    });
    expect(wrapper.find(CoreText)).toHaveLength(1);
  });

  it('skips rendering follower count with no followers field in response', () => {
    const { wrapper } = setup({
      channel: {
        followers: null,
        lastBroadcast: { startedAt: 'yesterday' },
      },
    });
    expect(wrapper.find(CoreText)).toHaveLength(1);
  });
});
