import { datatype, internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { SearchContentChannelName } from '../SearchContentChannelName';
import { SearchStreamCardBase } from '.';

describe('SearchStreamCard', () => {
  const setup = createShallowWrapperFactory(SearchStreamCardBase, () => ({
    stream: {
      ' $refType': 'SearchStreamCard_stream',
      broadcaster: {
        broadcastSettings: {
          title: lorem.word(),
        },
        displayName: 'foo',
        login: 'foo',
      },
      game: {
        displayName: 'bar',
        name: 'bar',
      },
      id: datatype.uuid(),
      previewImageURL: internet.url(),
      viewersCount: 100,
    },
  }));

  it('renders content channel name and viewer count', () => {
    const { wrapper } = setup();
    expect(wrapper.find(SearchContentChannelName)).toExist();
    expect(wrapper.find(CoreText)).toHaveLength(3);
  });

  it('skips rendering content channel name if there is no broadcast field', () => {
    const { wrapper } = setup({ stream: { broadcaster: null } });
    expect(wrapper.find(SearchContentChannelName)).not.toExist();
  });

  it('skips rendering viewer count if there is no viewers count', () => {
    const { wrapper } = setup({ stream: { viewersCount: null } });
    expect(wrapper.find(CoreText)).toHaveLength(2);
  });
});
