import { internet } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Input } from 'twitch-core-ui';
import {
  SEARCH_QUERY_PLATFORM,
  SEARCH_TERM_QUERY_PARAM_KEY,
} from '../../../config';
import { RouteName } from '../../../routing';
import { mockRouter } from '../../../routing/test-mocks';
import { SearchAutocomplete } from './SearchAutocomplete';
import { SearchContent } from './SearchContent';
import { Search } from '.';

jest.mock('../../../routing', () => ({
  ...jest.requireActual('../../../routing'),
  useTachyonRouter: () => mockRouter,
}));

describe(Search, () => {
  const setup = createShallowWrapperFactory(Search, () => {
    return {
      ' $fragmentRefs': {
        PageHead_query: true,
        SearchAutocomplete_suggestions: true,
        SearchContent_channels: true,
        SearchContent_games: true,
        SearchContent_overview: true,
        SearchContent_videos: true,
      },
      loading: false,
      queryVariables: {
        noQuery: false,
        noQueryFragment: true,
        platform: SEARCH_QUERY_PLATFORM,
        queryFragment: '',
        target: null,
        url: internet.url(),
        userQuery: '',
      },
    };
  });

  it('submits searches with the enter key', () => {
    const { wrapper } = setup();
    const blur = jest.fn();

    wrapper.find(Input).simulate('change', { currentTarget: { value: 'bob' } });
    wrapper
      .find(Input)
      .simulate('keydown', { currentTarget: { blur }, key: 'Enter' });

    expect(blur).toHaveBeenCalledTimes(1);
    expect(mockRouter.replace).toHaveBeenCalledWith(
      {
        route: RouteName.Search,
      },
      {
        [SEARCH_TERM_QUERY_PARAM_KEY]: 'bob',
      },
    );
  });

  it('renders search autocomplete when a search term is not present', () => {
    const { wrapper } = setup({ queryVariables: { userQuery: '' } });
    expect(wrapper.find(SearchAutocomplete)).toExist();
  });

  it('renders search content when a search term is present', () => {
    const { wrapper } = setup({ queryVariables: { userQuery: 'foo' } });
    expect(wrapper.find(SearchContent)).toExist();
  });
});
