import type { ParsedUrlQuery } from 'querystring';
import styled from 'styled-components';
import type { CoreInteractivePublicProps } from 'twitch-core-ui';
import { Layout } from 'twitch-core-ui';
import {
  SEARCH_TERM_QUERY_PARAM_KEY,
  SEARCH_TYPE_QUERY_PARAM_KEY,
} from '../../../config';
import { RouteName, renderTachyonLink } from '../../../routing';

// istanbul ignore next: trivial
export function getSearchLink(
  searchTerm: string,
  searchType?: SearchType,
): Pick<CoreInteractivePublicProps, 'linkTo' | 'renderLink'> {
  const query: ParsedUrlQuery = { [SEARCH_TERM_QUERY_PARAM_KEY]: searchTerm };
  if (searchType) {
    query[SEARCH_TYPE_QUERY_PARAM_KEY] = searchType;
  }

  return {
    linkTo: '/deferToRenderLink',
    renderLink: renderTachyonLink({
      query,
      // always replace so that the back button takes the user back to where they initiated the search
      replace: true,
      route: RouteName.Search,
    }),
  };
}

// istanbul ignore next: trivial
export const ScImageContainer = styled(Layout)`
  height: 9rem;
  max-width: 16rem;
`;

// istanbul ignore next: trivial
export enum SearchType {
  Category = 'categories',
  Channel = 'channels',
  Video = 'videos',
}
