import styled from 'styled-components';
import { useStaticEnvironment } from 'tachyon-environment';
import { useIntl } from 'tachyon-intl';
import { defaultPageviewTracking } from 'tachyon-page-utils';
import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FlexDirection,
  FlexWrap,
  FontSize,
  InjectLayout,
  Layout,
  SVG,
  SVGAsset,
  SVGType,
  TextAlign,
} from 'twitch-core-ui';
import { showOpenInApp } from '../../../utils';
import { OpenInApp } from '../../common';
import { Page } from '../../layouts';
import type { TomorrowPage } from '../types';

const ScHeading = styled.div`
  align-items: center;
  display: flex;
  justify-content: center;
  text-align: center;

  @media screen and (orientation: landscape) {
    height: 50%;
    width: 50%;
  }
`;

const ScImage = styled.div`
  align-items: center;
  display: flex;
  flex-grow: 1;
  justify-content: center;

  @media screen and (orientation: landscape) {
    height: 100%;
    order: 2;
    padding-left: 2rem;
    width: 50%;
  }
`;

const ScOpenInApp = styled.div`
  max-width: 300px;
  width: 100%;

  @media screen and (orientation: landscape) {
    align-items: center;
    display: flex;
    height: 50%;
    width: 50%;
  }
`;

const ScPage = styled(Layout)`
  margin: 0 auto;
  max-width: 1200px;
`;

// istanbul ignore next: trivial
export const Upsell: TomorrowPage = () => {
  const {
    client: { agentInfo },
  } = useStaticEnvironment();
  const { formatMessage } = useIntl();

  return (
    <Page hideTopNav>
      <ScPage
        alignItems={AlignItems.Center}
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        flexWrap={FlexWrap.Wrap}
        fullHeight
        fullWidth
        padding={5}
      >
        <ScHeading>
          <div>
            <SVG
              asset={SVGAsset.LogoTwitch}
              height={60}
              type={SVGType.Brand}
              width={180}
            />
            <Layout padding={{ top: 0.5 }}>
              <CoreText color={Color.Alt2} fontSize={FontSize.Size4}>
                {formatMessage(
                  'Watch and chat with your favorite broadcasters.',
                  'UpsellPage',
                )}
              </CoreText>
            </Layout>
          </div>
        </ScHeading>
        <ScImage>
          <Layout as="picture" textAlign={TextAlign.Center}>
            <source
              media={`
                      (min-width: 540px) and (orientation: portrait), (min-width: 813px) and (orientation: landscape)
                    `}
              srcSet={`
                      /static/images/upsell-phone.jpg 1x,
                      /static/images/upsell-phone@2x.jpg 2x,
                      /static/images/upsell-phone@3x.jpg 3x
                    `}
            />
            <InjectLayout fullWidth>
              <img
                src="/static/images/upsell-android.jpg"
                srcSet="/static/images/upsell-android.jpg 1x, /static/images/upsell-android@2x.jpg 2x, /static/images/upsell-android@3x.jpg 3x"
              />
            </InjectLayout>
          </Layout>
        </ScImage>
        {showOpenInApp(agentInfo) && (
          <ScOpenInApp>
            <OpenInApp callToActionIdentifier="upsell_page" fullWidth />
          </ScOpenInApp>
        )}
      </ScPage>
    </Page>
  );
};

Upsell.displayName = 'Upsell';
Upsell.pageviewTracking = defaultPageviewTracking;
Upsell.totalCacheLife = 1800;
Upsell.requiresJsForInteractivity = true;
