import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { reduceToNonNullNodes } from 'tachyon-utils';
import { Layout, Overflow } from 'twitch-core-ui';
import { VideoRowItem } from '../../../discovery';
import type { VodList_videos } from './__generated__/VodList_videos.graphql';

export type VodListProps = {
  videos: VodList_videos;
};

export const VodListBase: FC<VodListProps> = ({ videos }) => {
  const videoCards = reduceToNonNullNodes(videos.edges).map((v, idx) => (
    <Layout borderBottom borderTop={!idx} key={idx}>
      <VideoRowItem interactionContent={`position_${idx}`} video={v} />
    </Layout>
  ));

  return <Layout overflow={Overflow.Scroll}>{videoCards}</Layout>;
};

VodListBase.displayName = 'VodListBase';

export const VodList = createFragmentContainer(VodListBase, {
  videos: graphql`
    fragment VodList_videos on VideoConnection {
      edges {
        node {
          ...VideoRowItem_video
        }
      }
    }
  `,
});
