import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { VideoRowItem } from '../../../discovery';
import { VodListBase } from '.';

describe(VodListBase, () => {
  const setup = createShallowWrapperFactory(VodListBase, () => ({
    videos: {
      ' $refType': 'VodList_videos',
      edges: [
        {
          node: {
            ' $fragmentRefs': { VideoRowItem_video: true },
          },
        },
        {
          node: {
            ' $fragmentRefs': { VideoRowItem_video: true },
          },
        },
        {
          node: {
            ' $fragmentRefs': { VideoRowItem_video: true },
          },
        },
      ],
    },
  }));

  it('renders a card for each provided clip', () => {
    const { props, wrapper } = setup();

    expect(wrapper.find(VideoRowItem)).toHaveLength(props.videos.edges!.length);
  });
});
