import { internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { WebShareButton } from '../../../common';
import { VodList } from '../VodList';
import { VodPanelBase } from '.';

let mockCanShare = true;

jest.mock('../../../common', () => ({
  ...jest.requireActual('../../../common'),
  canShare: () => mockCanShare,
}));

describe(VodPanelBase, () => {
  const setup = createShallowWrapperFactory(VodPanelBase, () => ({
    video: {
      ' $fragmentRefs': { TagList_video: true },
      ' $refType': 'VodPanel_video',
      game: {
        displayName: lorem.words(3),
        name: lorem.words(3),
      },
      owner: {
        displayName: internet.userName(),
        login: internet.userName(),
        profileImageURL: internet.url(),
        videos: {
          ' $fragmentRefs': { VodList_videos: true },
        },
      },
      title: lorem.words(10),
    },
  }));

  beforeEach(() => {
    mockCanShare = true;
  });

  it('does not render the share feature if not supported', () => {
    mockCanShare = false;
    const { wrapper } = setup();
    expect(wrapper.find(WebShareButton)).not.toExist();
  });

  it('renders the share feature if supported', () => {
    const { wrapper } = setup();
    expect(wrapper.find(WebShareButton)).toExist();
  });

  it('renders a clip list when clips are returned', () => {
    const { wrapper } = setup();
    expect(wrapper.find(VodList)).toExist();
  });

  it('does not render a clip list when no clips are returned', () => {
    const { wrapper } = setup({ video: { owner: { videos: null } } });
    expect(wrapper.find(VodList)).not.toExist();
  });
});
